#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//MandalaMod01.fsh   by  xbe   
//https://www.shadertoy.com/view/MtcSz4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318 //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Xavier Benech
// Mandala 2D
//
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

#define PI 3.14159265

#define aspect (iResolution.x/iResolution.y)

float circle(vec2 p, float r, float width)
{
    float d = 0.;
    d += smoothstep(1., 0., width*abs(p.x - r));
    return d;
}

float arc(vec2 p, float r, float a, float width)
{
    float d = 0.;
    if (abs(p.y) < a) {
	    d += smoothstep(1., 0., width*abs(p.x - r));
    }
    return d;
}


float rose(vec2 p, float t, float width)
{
    const float a0 = 6.;
    float d = 0.;
    p.x *= 7. + 8. * t;
    d += smoothstep(1., 0., width*abs(p.x - sin(a0*p.y)));
    d += smoothstep(1., 0., width*abs(p.x - abs(sin(a0*p.y))));
    d += smoothstep(1., 0., width*abs(abs(p.x) - sin(a0*p.y)));
    d += smoothstep(1., 0., width*abs(abs(p.x) - abs(sin(a0*p.y))));
    return d;
}

float rose2(vec2 p, float t, float width)
{
    const float a0 = 6.;
    float d = 0.;
    p.x *= 7. + 8. * t;
    d += smoothstep(1., 0., width*abs(p.x - cos(a0*p.y)));
    d += smoothstep(1., 0., width*abs(p.x - abs(cos(a0*p.y))));
    d += smoothstep(1., 0., width*abs(abs(p.x) - cos(a0*p.y)));
    d += smoothstep(1., 0., width*abs(abs(p.x) - abs(cos(a0*p.y))));
    return d;
}

float spiral(vec2 p, float width)
{
    float d = 0.;
    d += smoothstep(1., 0., width*abs(p.x - 0.5 * p.y / PI));
    d += smoothstep(1., 0., width*abs(p.x - 0.5 * abs(p.y) / PI));
    d += smoothstep(1., 0., width*abs(abs(p.x) - 0.5 * p.y / PI));
    d += smoothstep(1., 0., width*abs(abs(p.x) - 0.5 * abs(p.y) / PI));
    return d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
 	vec2 uv = fragCoord.xy / iResolution.xy;
    vec2 p = uv - 0.5;
	p.x *= aspect;

    vec2 f = vec2 ( sqrt(p.x*p.x + p.y*p.y), atan(p.y, p.x) );

    float T0 = cos(0.3*iTime);
    float T1 = 0.5 + 0.5 * cos(0.3*iTime);
    float T2 = sin(0.15*iTime);
    
    float m0 = 0.;
    float m1 = 0.;
    float m2 = 0.;
    float m3 = 0.;
    float m4 = 0.;
    if (f.x < 0.7325) {
        f.y += 0.1 * iTime;
	    vec2 c;
	    vec2 f2;
        c = vec2(0.225 - 0.1*T0, PI / 4.);
        if (f.x < 0.25) {
            for (float i=0.; i < 2.; ++i) {
                f2 = mod(f, c) - 0.5 * c;
                m0 += spiral(vec2(f2.x, f2.y), 192.);
            }
    	}
        c = vec2(0.225 + 0.1*T0, PI / 4.);
        if (f.x > 0.43) {
            for (float i=0.; i < 2.; ++i) {
                f.y += PI / 8.;
            	f2 = mod(f, c) - 0.5 * c;
                m1 += rose((0.75-0.5*T0)*f2, 0.4*T1, 24.);
                m1 += rose2((0.5+0.5*T1)*f2, 0.2 + 0.2*T0, 36.);
            }
	    }
        c = vec2(0.6 - 0.2*T0, PI / 4.);
        if (f.x > 0.265) {
            for (float i=0.; i < 2.; ++i) {
                f.y += PI / 8.;
                f2 = mod(f, c) - 0.5 * c;
                m2 += spiral(vec2((0.25 + 0.5*T1)*f2.x, f2.y), 392.);
                m2 += rose2((1.+0.25*T0)*f2, 0.5, 24.);
            }
        }
        c = vec2(0.4 + 0.23*T0, PI / 4.);
        if (f.x < 0.265) {
            for (float i=0.; i < 2.; ++i) {
                f.y += PI / 8.;
                f2 = mod(f, c) - 0.5 * c;
                m3 += spiral(vec2(f2.x, f2.y), 256.);
                m3 += rose(f2, 1.5 * T1, 16.);
            }
        }
        m4 += circle(f, 0.040, 192.);
        m4 += circle(f, 0.265, 192.);
        m4 += circle(f, 0.430, 192.);
    }
    m4 += circle(f, 0.7325, 192.);

    // color
    float z = m0 + m1 + m2 + m3 + m4;
    z *= z;
    z = clamp(z, 0., 1.);
    vec3 col = vec3(z) * vec3(0.33*T2);
    
    // Background
	vec3 bkg = vec3(0.32,0.36,0.4) + p.y*0.1;
	col += bkg;
    
	// Vignetting
	vec2 r = -1.0 + 2.0*(uv);
	float vb = max(abs(r.x), abs(r.y));
	col *= (0.15 + 0.85*(1.0-exp(-(1.0-vb)*30.0)));

    fragColor = vec4( col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

